//
//  RVSerialHardwareCommunicator.h
//  CommunicationModule
//
//  Created by Greg Harris on 9/21/12.
//  Copyright (c) 2012 Renewed Vision, LLC. All rights reserved.
//

#import "RVHardwareCommunicator.h"
#import <termios.h>

@protocol RVSerialProtocolParser;

extern NSString *RVSerialCommunicatorSerializationKeyAttributeInterface;
extern NSString *RVSerialCommunicatorSerializationKeyAttributeSpeed;
extern NSString *RVSerialCommunicatorSerializationKeyAttributeDataBits;
extern NSString *RVSerialCommunicatorSerializationKeyAttributeParity;
extern NSString *RVSerialCommunicatorSerializationKeyAttributeStopBits;
extern NSString *RVSerialCommunicatorSerializationKeyAttributeHFCInput;
extern NSString *RVSerialCommunicatorSerializationKeyAttributeHFCOutput;

typedef enum _RVSerialPortOptionSpeed {
	RVSerialPortOptionSpeedUnknown = -1,
	RVSerialPortOptionSpeed1200 = 1200,
	RVSerialPortOptionSpeed1800 = 1800,
	RVSerialPortOptionSpeed2400 = 2400,
	RVSerialPortOptionSpeed4800 = 4800,
	RVSerialPortOptionSpeed7200 = 7200,
	RVSerialPortOptionSpeed9600 = 9600,
	RVSerialPortOptionSpeed14400 = 14400,
	RVSerialPortOptionSpeed19200 = 19200,
	RVSerialPortOptionSpeed28800 = 28800,
	RVSerialPortOptionSpeed38400 = 38400,
	RVSerialPortOptionSpeed57600 = 57600,
	RVSerialPortOptionSpeed76800 = 76800,
	RVSerialPortOptionSpeed115200 = 115200,
	RVSerialPortOptionSpeed230400 = 230400,
} RVSerialPortOptionSpeed;

typedef enum _RVSerialPortOptionDataBits {
	RVSerialPortOptionDataBitsUnknown = -1,
	RVSerialPortOptionDataBits5 = 5,
	RVSerialPortOptionDataBits6 = 6,
	RVSerialPortOptionDataBits7 = 7,
	RVSerialPortOptionDataBits8 = 8,
} RVSerialPortOptionDataBits;

typedef enum _RVSerialPortOptionParity {
	RVSerialPortOptionParityUnknown = -1,
	RVSerialPortOptionParityNone = 0,
	RVSerialPortOptionParityOdd = 1,
	RVSerialPortOptionParityEven = 2,
} RVSerialPortOptionParity;

typedef enum _RVSerialPortOptionStopBits {
	RVSerialPortOptionStopBitsUnknown = -1,
	RVSerialPortOptionStopBits1 = 1,
	RVSerialPortOptionStopBits2 = 2,
} RVSerialPortOptionStopBits;

typedef enum _RVSerialPortOptionHardwareFlowControlInput {
	RVSerialPortOptionHardwareFlowControlInputUnknown = -1,
	RVSerialPortOptionHardwareFlowControlInputNone = 0,
	RVSerialPortOptionHardwareFlowControlInputRTS = 1,
	RVSerialPortOptionHardwareFlowControlInputDTR = 2,
} RVSerialPortOptionHardwareFlowControlInput;

typedef enum _RVSerialPortOptionHardwareFlowControlOutput {
	RVSerialPortOptionHardwareFlowControlOutputUnknown = -1,
	RVSerialPortOptionHardwareFlowControlOutputNone = 0,
	RVSerialPortOptionHardwareFlowControlOutputCTS = 3,
	RVSerialPortOptionHardwareFlowControlOutputDSR = 4,
	RVSerialPortOptionHardwareFlowControlOutputCAR = 5,
} RVSerialPortOptionHardwareFlowControlOutput;

@interface RVSerialHardwareCommunicator : RVHardwareCommunicator {
	int serialPortFD;
	NSString *devicePath;
	struct termios originalSerialPortAttrs;
	
	IBOutlet NSView *setupView;
	IBOutlet NSPopUpButton *interfacePopupButton, *speedPopupButton;
	IBOutlet NSPopUpButton *dataBitsPopupButton, *parityPopupButton, *stopBitsPopupButton;
	IBOutlet NSPopUpButton *hfcInputPopupButton, *hfcOutputPopupButton;
	
	dispatch_queue_t readQueue;
	dispatch_source_t readSource;
	
	RVSerialPortOptionSpeed speed;
	RVSerialPortOptionDataBits dataBits;
	RVSerialPortOptionParity parity;
	RVSerialPortOptionStopBits stopBits;
	RVSerialPortOptionHardwareFlowControlInput hfci;
	RVSerialPortOptionHardwareFlowControlOutput hfco;
	
	NSMenuItem *selectedInterfaceItem;
	NSArray *cachedAvailableInterfaces;
}

@property (copy) NSString *devicePath;
@property (assign) RVSerialPortOptionSpeed speed;
@property (assign) RVSerialPortOptionDataBits dataBits;
@property (assign) RVSerialPortOptionParity parity;
@property (assign) RVSerialPortOptionStopBits stopBits;
@property (assign) RVSerialPortOptionHardwareFlowControlInput hfci;
@property (assign) RVSerialPortOptionHardwareFlowControlOutput hfco;
@property (retain, nonatomic) NSMenuItem *selectedInterfaceItem;

- (IBAction) connectAction:(id)sender;

- (IBAction) speedAction:(id)sender;
- (IBAction) dataBitsAction:(id)sender;
- (IBAction) parityAction:(id)sender;
- (IBAction) stopBitsAction:(id)sender;
- (IBAction) hfciAction:(id)sender;
- (IBAction) hfcoAction:(id)sender;

- (void) writeData:(NSData *)data;
- (void) read;

- (RVProtocolParser <RVSerialProtocolParser> *)parser;

@end

@protocol RVSerialProtocolParser

- (void) serialHardware:(RVSerialHardwareCommunicator *)hw readData:(NSData *)data;

@optional
- (void) serialPortDidConnectForSerialHardware:(RVSerialHardwareCommunicator *)hw;
- (void) serialPortDidDisconnectForSerialHardware:(RVSerialHardwareCommunicator *)hw;

- (BOOL) shouldSwapBlackMagicSerialLinesForSerialHardware:(RVSerialHardwareCommunicator *)hw;

- (RVSerialPortOptionSpeed) preferredSpeedForSerialHardware:(RVSerialHardwareCommunicator *)hw;
- (RVSerialPortOptionDataBits) preferredDataBitsForSerialHardware:(RVSerialHardwareCommunicator *)hw;
- (RVSerialPortOptionParity) preferredParityForSerialHardware:(RVSerialHardwareCommunicator *)hw;
- (RVSerialPortOptionStopBits) preferredStopBitsForSerialHardware:(RVSerialHardwareCommunicator *)hw;
- (RVSerialPortOptionHardwareFlowControlInput) preferredHardwareFlowControlInputForSerialHardware:(RVSerialHardwareCommunicator *)hw;
- (RVSerialPortOptionHardwareFlowControlOutput) preferredHardwareFlowControlOutputForSerialHardware:(RVSerialHardwareCommunicator *)hw;

@end

